jQuery(document).ready(function($){
    $('#mkrc-run').on('click', function(e){
        e.preventDefault();
        var domain = $('#mkrc-domain').val().trim();
        var api_key = $('#mkrc-api-key').val().trim();
        var cx = $('#mkrc-cx').val().trim();
        var keywords = $('#mkrc-keywords').val();
        var max_results = $('#mkrc-max-results').val();

        if (!domain || !api_key || !cx || !keywords) {
            alert('Vui lòng điền đủ domain, API key, cx và từ khóa.');
            return;
        }

        $('#mkrc-results').html('<p>Đang kiểm tra... Vui lòng chờ.</p>');

        $.post(mkrc_ajax.ajax_url, {
            action: 'mkrc_check_rank',
            nonce: mkrc_ajax.nonce,
            domain: domain,
            api_key: api_key,
            cx: cx,
            keywords: keywords,
            max_results: max_results
        }, function(res){
            if (!res.success) {
                $('#mkrc-results').html('<div class="notice notice-error"><p>Error: '+(res.data||'Unknown')+'</p></div>');
                return;
            }
            var html = '<table class="widefat"><thead><tr><th>Keyword</th><th>Position</th><th>URL</th></tr></thead><tbody>';
            var data = res.data;
            for (var k in data) {
                var row = data[k];
                var pos = row.position ? row.position : 'Not in top '+max_results;
                var url = row.url ? '<a href="'+row.url+'" target="_blank">'+row.url+'</a>' : '-';
                html += '<tr><td>'+k+'</td><td>'+pos+'</td><td>'+url+'</td></tr>';
            }
            html += '</tbody></table>';
            $('#mkrc-results').html(html);
        }, 'json').fail(function(xhr){
            $('#mkrc-results').html('<div class="notice notice-error"><p>Request failed: '+xhr.statusText+'</p></div>');
        });
    });
});
