<?php
/*
Plugin Name: Multi Keyword Rank Checker
Description: Kiểm tra thứ hạng nhiều từ khóa của website trên Google Search (sử dụng Google Custom Search JSON API).
Version: 1.1
Author: ChatGPT
*/

if ( ! defined( 'ABSPATH' ) ) exit;

class MKRC_Plugin {
    public function __construct() {
        add_action('admin_menu', array($this,'mkrc_add_admin_page'));
        add_action('admin_enqueue_scripts', array($this,'mkrc_enqueue'));
        add_action('wp_ajax_mkrc_check_rank', array($this,'mkrc_check_rank'));
    }

    public function mkrc_add_admin_page() {
        add_menu_page('Rank Checker', 'Rank Checker', 'manage_options', 'mkrc-rank-checker', array($this,'mkrc_admin_page'), 'dashicons-chart-area', 80);
    }

    public function mkrc_enqueue($hook) {
        if ($hook !== 'toplevel_page_mkrc-rank-checker') return;
        wp_enqueue_script('mkrc-js', plugin_dir_url(__FILE__).'mkrc.js', array('jquery'), '1.0', true);
        wp_localize_script('mkrc-js', 'mkrc_ajax', array('ajax_url'=>admin_url('admin-ajax.php'), 'nonce'=>wp_create_nonce('mkrc_nonce')));
        wp_enqueue_style('mkrc-css', plugin_dir_url(__FILE__).'mkrc.css');
    }

    public function mkrc_admin_page() {
        ?>
        <div class="wrap">
            <h1>Multi Keyword Rank Checker</h1>
            <p>Nhập domain, danh sách từ khóa (mỗi dòng 1 từ khóa), API key và Search Engine ID (cx).</p>

            <table class="form-table">
            <tr><th>Domain</th><td><input type="text" id="mkrc-domain" style="width:300px" placeholder="example.com"></td></tr>
            <tr><th>API Key</th><td><input type="text" id="mkrc-api-key" style="width:500px" placeholder="Google API Key"></td></tr>
            <tr><th>Search Engine ID (cx)</th><td><input type="text" id="mkrc-cx" style="width:300px" placeholder="Search Engine ID"></td></tr>
            <tr><th>Max results to search</th><td>
                <select id="mkrc-max-results">
                    <option value="10">Top 10</option>
                    <option value="20">Top 20</option>
                    <option value="50" selected>Top 50</option>
                </select>
            </td></tr>
            <tr><th>Keywords</th><td><textarea id="mkrc-keywords" rows="10" cols="70" placeholder="mỗi dòng 1 từ khóa"></textarea></td></tr>
            </table>

            <p><button id="mkrc-run" class="button button-primary">Kiểm tra</button></p>
            <div id="mkrc-results"></div>
        </div>
        <?php
    }

    public function mkrc_check_rank() {
        if (!current_user_can('manage_options')) wp_send_json_error('No permission');
        check_ajax_referer('mkrc_nonce', 'nonce');

        $domain = sanitize_text_field($_POST['domain'] ?? '');
        $api_key = sanitize_text_field($_POST['api_key'] ?? '');
        $cx = sanitize_text_field($_POST['cx'] ?? '');
        $max_results = intval($_POST['max_results'] ?? 50);
        $keywords_raw = wp_unslash($_POST['keywords'] ?? '');

        if (empty($domain) || empty($api_key) || empty($cx) || empty($keywords_raw)) {
            wp_send_json_error('Missing parameters');
        }

        $keywords = array_filter(array_map('trim', explode("\n", $keywords_raw)));
        $results = array();

        foreach ($keywords as $kw) {
            $found_pos = null;
            $found_url = null;
            $per_page = 10;
            $pages = ceil($max_results / $per_page);

            for ($p=0; $p < $pages; $p++) {
                $start = $p * $per_page + 1;
                $api_url = add_query_arg(array(
                    'key' => $api_key,
                    'cx' => $cx,
                    'q' => $kw,
                    'start' => $start,
                ), 'https://www.googleapis.com/customsearch/v1');

                $resp = wp_remote_get($api_url, array('timeout'=>20));
                if (is_wp_error($resp)) {
                    $results[$kw] = array('error' => $resp->get_error_message());
                    break 2;
                }
                $code = wp_remote_retrieve_response_code($resp);
                $body = wp_remote_retrieve_body($resp);
                $data = json_decode($body, true);
                if ($code !== 200 || empty($data)) {
                    $results[$kw] = array('error' => $data['error']['message'] ?? 'API error');
                    break 2;
                }
                if (!isset($data['items'])) continue;

                foreach ($data['items'] as $idx => $item) {
                    $link = $item['link'] ?? '';
                    $host = parse_url($link, PHP_URL_HOST);
                    if ($host && (stripos($host, $domain) !== false || stripos($link, $domain) !== false)) {
                        $found_pos = ($p * $per_page) + $idx + 1;
                        $found_url = $link;
                        break 2;
                    }
                }
                usleep(150000);
            }

            $results[$kw] = $found_pos ? array('position'=>$found_pos,'url'=>$found_url) : array('position'=>null,'url'=>null);
        }

        wp_send_json_success($results);
    }
}
new MKRC_Plugin();
